package com.hero.ui.dialog;

import java.awt.GridBagConstraints;
import java.awt.Insets;

import javax.swing.JLabel;
import javax.swing.JPanel;

import com.hero.objects.perks.Contact;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class ContactDialog extends PerkDialog {

	private static final long serialVersionUID = -5519841924491965175L;

	private JLabel rollLbl;

	public ContactDialog(Contact pk, boolean isNew, boolean isPower) {
		super(pk, isNew, isPower);
		if (pointsLbl != null) {
			pointsLbl.setVisible(false);
		}
		if (pointsTF != null) {
			pointsTF.setVisible(false);
		}
		levelsLbl.setText("Points:");
	}

	@Override
	protected JPanel getTopPanel() {
		JPanel panel = super.getTopPanel();
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.insets = new Insets(5, 5, 5, 5);
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.gridy = 70;
		gbc.gridx = 2;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 1;
		panel.add(rollLbl, gbc);
		return panel;
	}

	@Override
	protected void initListeners() {
		super.initListeners();
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		rollLbl = new JLabel("Roll:");
	}

	@Override
	public void updateValues() {
		rollLbl.setText("Roll: " + perk.getRoll());
		super.updateValues();
	}
}